<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SellingSpecialNumber extends Model 
{

    protected $table = 'selling_special_numbers';
    public $timestamps = true;
    protected $fillable = array('id', 'name_ar', 'name_en', 'description_ar', 'description_en', 'record_number', 'logo', 'active', 'availablity', 'country_id');

    public function contact()
    {
        return $this->morphOne('App\Models\Contact', 'contactable');
    }

    public function favourites()
    {
        return $this->morphToMany('App\Models\User', 'favouriable');
    }

    public function reviews()
    {
        return $this->morphToMany('App\Models\User', 'reviewable');
    }

    public function special_numbers()
    {
        return $this->hasMany('App\Models\SpecialNumber');
    }

    public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }

}